/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomes.core.api;

import com.blackgear.cavebiomes.mixin.core.NetherBiomeProviderAccessor;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.NetherBiomeProvider;

public class CaveLayer {
    public static final Map<RegistryKey<Biome>, Biome.Attributes> CAVE_BIOMES = new HashMap<RegistryKey<Biome>, Biome.Attributes>();
    public static final List<Biome> CAVE_BIOME_LIST = new ArrayList<Biome>();
    public static final NetherBiomeProvider.Preset CENTER_BIOME_PROVIDER = new NetherBiomeProvider.Preset(new ResourceLocation("cavebiomeapi", "cave_biome_provider"), (preset, biomeRegistry, seed) -> {
        ArrayList<Pair<Biome.Attributes, Supplier<Biome>>> biomes = new ArrayList<Pair<Biome.Attributes, Supplier<Biome>>>();
        CAVE_BIOMES.forEach((biomeKey, noisePoint) -> {
            Biome biome = (Biome)biomeRegistry.func_243576_d(biomeKey);
            biomes.add(Pair.of((Object)noisePoint, () -> biome));
        });
        NetherBiomeProvider.Noise temperatureNoise = CaveLayer.createNoiseParameters(-9, 1.5, 0.0, 1.0, 0.0, 0.0, 0.0);
        NetherBiomeProvider.Noise humidityNoise = CaveLayer.createNoiseParameters(-7, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0);
        NetherBiomeProvider.Noise altitudeNoise = CaveLayer.createNoiseParameters(-9, 1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0);
        NetherBiomeProvider.Noise weirdnessNoise = CaveLayer.createNoiseParameters(-7, 1.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0);
        return NetherBiomeProviderAccessor.createNetherBiomeProvider(seed, biomes, temperatureNoise, humidityNoise, altitudeNoise, weirdnessNoise, Optional.empty());
    });

    public static NetherBiomeProvider create(Registry<Biome> biomes, long seed) {
        CAVE_BIOME_LIST.addAll(CAVE_BIOMES.keySet().stream().map(arg_0 -> biomes.func_230516_a_(arg_0)).collect(Collectors.toList()));
        return CENTER_BIOME_PROVIDER.func_242619_a(biomes, seed);
    }

    public static void addCaveBiome(RegistryKey<Biome> biome, Biome.Attributes noise) {
        Preconditions.checkNotNull(biome, (Object)"biome is null");
        Preconditions.checkNotNull((Object)noise, (Object)"noise is null");
        CAVE_BIOMES.put(biome, noise);
    }

    private static NetherBiomeProvider.Noise createNoiseParameters(int firstOctave, double ... amplitudes) {
        return new NetherBiomeProvider.Noise(firstOctave, (List)new DoubleArrayList(amplitudes));
    }
}

